/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightTags;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class ImmortalersKnifeItem
extends KnifeItem {
    public static final int ANCIENT_KNIFE_TYPE = 1;
    public static final int NEW_ANCIENT_KNIFE_TYPE = 2;
    public static final int PILLAGER_KNIFE_TYPE = 3;
    public static final int BONE_KNIFE_TYPE = 4;
    public static final String ANCIENT_KNIFE_COMBO_SKILL = "immortalers_delight_ancient_knife_combo_skill";
    protected int type_id;
    protected final float attackDamage;
    protected final float attackSpeed;
    protected final float extra_attackDamage;
    protected final float extra_attackSpeed;

    public int getTypeId() {
        return this.type_id;
    }

    public ImmortalersKnifeItem(int type, Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
        this.type_id = type;
        this.attackDamage = attackDamage + tier.m_6631_();
        this.attackSpeed = attackSpeed;
        this.extra_attackDamage = 0.0f;
        this.extra_attackSpeed = 0.0f;
    }

    public ImmortalersKnifeItem(int type, Tier tier, float attackDamage, float attackSpeed, float extra_attackDamage, float extra_attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
        this.type_id = type;
        this.attackDamage = attackDamage + tier.m_6631_();
        this.attackSpeed = attackSpeed;
        this.extra_attackDamage = extra_attackDamage;
        this.extra_attackSpeed = extra_attackSpeed;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack);
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        int type = this.type_id;
        if (type == 3 && enchantment == Enchantments.f_44982_) {
            level += isPowerful ? 4 : 2;
        }
        if (type == 4 && enchantment == Enchantments.f_44982_ && level > 0) {
            --level;
        }
        return level;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.attackSpeed + (double)(isPowerful ? this.extra_attackSpeed : 0.0f), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage + (double)(isPowerful ? this.extra_attackDamage : 0.0f), AttributeModifier.Operation.ADDITION));
            return multimap;
        }
        return super.m_7167_(equipmentSlot);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        MutableComponent textEmpty;
        if (this.type_id == 1) {
            textEmpty = TextUtils.getTranslation((String)("tooltip." + this), (Object[])new Object[0]);
            tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
        }
        if (this.type_id == 2) {
            for (int i = 0; i < 3; ++i) {
                MutableComponent textEmpty2 = TextUtils.getTranslation((String)("tooltip." + this + "." + (Serializable)(i == 2 && DifficultyModeUtil.isPowerBattleMode() ? "power" : Integer.valueOf(i))), (Object[])new Object[0]);
                if (i == 1) {
                    tooltip.add((Component)textEmpty2.m_130940_(ChatFormatting.GRAY));
                    continue;
                }
                if (i == 2) {
                    tooltip.add((Component)textEmpty2.m_130940_(ChatFormatting.DARK_GREEN));
                    continue;
                }
                tooltip.add((Component)textEmpty2.m_130940_(ChatFormatting.BLUE));
            }
        }
        if (this.type_id == 4) {
            textEmpty = TextUtils.getTranslation((String)("tooltip." + this), (Object[])new Object[0]);
            tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.YELLOW));
            MutableComponent textEmpty1 = TextUtils.getTranslation((String)("tooltip." + this + ".1"), (Object[])new Object[0]);
            tooltip.add((Component)textEmpty1.m_130940_(ChatFormatting.RED));
        }
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ImmortalersKnifeEvents {
        @SubscribeEvent
        public static void ImmortalersKnifeAttack(LivingHurtEvent event) {
            Item item;
            LivingEntity attacker;
            ItemStack toolStack;
            if (event.isCanceled()) {
                return;
            }
            boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
            LivingEntity hurtOne = event.getEntity();
            if (hurtOne.m_9236_().f_46443_) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity && !(toolStack = (attacker = (LivingEntity)entity).m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && (item = toolStack.m_41720_()) instanceof ImmortalersKnifeItem) {
                ItemStack toolStack2;
                ImmortalersKnifeItem knife = (ImmortalersKnifeItem)item;
                if (knife.getTypeId() == 1) {
                    hurtOne.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.WEAK_WITHER.get(), 320, isPowerful ? 2 : 1));
                }
                if (knife.getTypeId() == 2 && !(toolStack2 = attacker.m_21120_(InteractionHand.OFF_HAND)).m_41619_() && toolStack2.m_150930_((Item)ImmortalersDelightItems.ANCIENT_BLADE.get())) {
                    float buffer = event.getAmount() * 0.6f;
                    if (!isPowerful && buffer > 4.0f) {
                        buffer = 4.0f;
                    }
                    event.setAmount(event.getAmount() + buffer);
                    if (attacker instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)attacker;
                        if (!serverPlayer.m_150110_().f_35937_) {
                            toolStack2.m_41622_(1, (LivingEntity)serverPlayer, action -> action.m_21190_(InteractionHand.OFF_HAND));
                        }
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onCakeInteraction(PlayerInteractEvent.RightClickBlock event) {
            ItemStack toolStack = event.getEntity().m_21120_(event.getHand());
            if (toolStack.m_204117_(ImmortalersDelightTags.IMMORTAL_KNIVES)) {
                Level level = event.getLevel();
                BlockPos pos = event.getPos();
                BlockState state = event.getLevel().m_8055_(pos);
                Block block = state.m_60734_();
                if (state.m_204336_(ModTags.DROPS_CAKE_SLICE)) {
                    level.m_7731_(pos, (BlockState)Blocks.f_50145_.m_49966_().m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(1)), 3);
                    Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                    ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)ModItems.CAKE_SLICE.get()), (double)pos.m_123341_(), (double)((double)pos.m_123342_() + 0.2), (double)((double)pos.m_123343_() + 0.5), (double)-0.05, (double)0.0, (double)0.0);
                    level.m_5594_((Player)null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
                if (block == Blocks.f_50145_) {
                    int bites = (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
                    if (bites < 6) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(bites + 1)), 3);
                    } else {
                        level.m_7471_(pos, false);
                    }
                    ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)ModItems.CAKE_SLICE.get()), (double)((double)pos.m_123341_() + (double)bites * 0.1), (double)((double)pos.m_123342_() + 0.2), (double)((double)pos.m_123343_() + 0.5), (double)-0.05, (double)0.0, (double)0.0);
                    level.m_5594_((Player)null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }
}

